/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.block.AmplifierBlock;
import DE.siemens.ad.logo.model.block.AnalogComparatorBlock;
import DE.siemens.ad.logo.model.block.AnalogDeltaTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.block.AnalogMuxBlock;
import DE.siemens.ad.logo.model.block.AnalogTriggerBlock;
import DE.siemens.ad.logo.model.block.AnalogWatchdogBlock;
import DE.siemens.ad.logo.model.block.AsymPulseGeneratorBlock;
import DE.siemens.ad.logo.model.block.ComfortSwitchBlock;
import DE.siemens.ad.logo.model.block.CounterBlock;
import DE.siemens.ad.logo.model.block.HoursCounterBlock;
import DE.siemens.ad.logo.model.block.MathDetectionBlock;
import DE.siemens.ad.logo.model.block.OffDelayBlock;
import DE.siemens.ad.logo.model.block.OnDelayBlock;
import DE.siemens.ad.logo.model.block.OnOffDelayBlock;
import DE.siemens.ad.logo.model.block.PIDBlock;
import DE.siemens.ad.logo.model.block.PWMBlock;
import DE.siemens.ad.logo.model.block.RampControlBlock;
import DE.siemens.ad.logo.model.block.RandomBlock;
import DE.siemens.ad.logo.model.block.RetentiveOnDelayBlock;
import DE.siemens.ad.logo.model.block.ShiftRegisterBlock;
import DE.siemens.ad.logo.model.block.SoftkeyBlock;
import DE.siemens.ad.logo.model.block.StairsSwitchBlock;
import DE.siemens.ad.logo.model.block.TriggerBlock;
import DE.siemens.ad.logo.model.block.WipingRelayBlock;
import DE.siemens.ad.logo.model.block.WipingRelayPECBlock;
import DE.siemens.ad.logo.model.hardware.Logo6;
import DE.siemens.ad.logo.model.visitor.build.CompilerFromLogo4;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Util;

public class ActualValueVisitor
extends Visitor {
    protected int[] fBuffer;
    protected int fBufferPointer;
    protected CompilerFromLogo4 fCompiler = new CompilerFromLogo4();

    protected void ignoreBytes(int count) {
        for (int i = 0; i < count; ++i) {
            this.getByte();
        }
    }

    public Object visit(OnDelayBlock onDelayBlock) {
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(AsymPulseGeneratorBlock asymPulseGeneratorBlock) {
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(RandomBlock randomBlock) {
        this.ignoreBytes(4);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(OnOffDelayBlock onOffDelayBlock) {
        this.ignoreBytes(4);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(StairsSwitchBlock stairsSwitchBlock) {
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(ComfortSwitchBlock comfortSwitchBlock) {
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(WipingRelayPECBlock wipingRelayPECBlock) {
        this.ignoreBytes(4);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(ShiftRegisterBlock shiftRegisterBlock) {
        this.ignoreBytes(2);
        return "";
    }

    public Object visit(AnalogTriggerBlock analogTriggerBlock) {
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        String value = Double.toString(ax);
        value = "       ".substring(value.length()) + value;
        this.ignoreBytes(2);
        return value;
    }

    public Object visit(AnalogDeltaTriggerBlock analogDeltaTriggerBlock) {
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        String value = Double.toString(ax);
        value = "       ".substring(value.length()) + value;
        this.ignoreBytes(2);
        return value;
    }

    public Object visit(AnalogWatchdogBlock analogWatchdogBlock) {
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        int aen = this.parseAnalogValue();
        if (!(analogWatchdogBlock.getHardware() instanceof Logo6)) {
            this.ignoreBytes(4);
        } else {
            int temp = ax;
            ax = aen;
            aen = temp;
            this.ignoreBytes(2);
        }
        String axValue = Double.toString(ax);
        axValue = "       ".substring(axValue.length()) + axValue;
        String aenValue = Double.toString(aen);
        aenValue = "       ".substring(aenValue.length()) + aenValue;
        StringBuffer value = new StringBuffer();
        value.append(axValue).append("\n").append(aenValue);
        return value.toString();
    }

    public Object visit(AnalogComparatorBlock analogComparatorBlock) {
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        int ay = this.parseAnalogValue();
        int delta = this.parseAnalogValue();
        String axValue = Integer.toString(ax);
        axValue = "       ".substring(axValue.length()) + axValue;
        String ayValue = Integer.toString(ay);
        ayValue = "       ".substring(ayValue.length()) + ayValue;
        String deltaValue = Integer.toString(delta);
        deltaValue = "       ".substring(deltaValue.length()) + deltaValue;
        this.ignoreBytes(4);
        return axValue + "\n" + ayValue + "\n" + deltaValue;
    }

    public Object visit(AmplifierBlock amplifierBlock) {
        int ax = this.parseAnalogValue();
        String axValue = Integer.toString(ax);
        axValue = "       ".substring(axValue.length()) + axValue;
        this.ignoreBytes(2);
        return axValue;
    }

    public Object visit(OffDelayBlock offDelayBlock) {
        this.ignoreBytes(4);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(RetentiveOnDelayBlock retentiveOnDelayBlock) {
        this.ignoreBytes(4);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(HoursCounterBlock hoursCounterBlock) {
        this.ignoreBytes(1);
        int mn = 0;
        mn += this.getByte();
        mn += this.getByte() << 8;
        mn += this.getByte() << 16;
        mn += (this.getByte() & 0x3F) << 24;
        int ot = 0;
        ot += this.getByte();
        ot += this.getByte() << 8;
        ot += this.getByte() << 16;
        this.ignoreBytes(2);
        return "OT=" + this.formatHoursCounterTime(ot += this.getByte() << 24) + "\nMN=" + this.formatHoursCounterTime(mn);
    }

    protected String formatHoursCounterTime(int minutes) {
        int hour = minutes / 60;
        int min = minutes % 60;
        String minuteString = Util.addLeadingZeros(Integer.toString(min), 2);
        return hour + ":" + minuteString;
    }

    public Object visit(WipingRelayBlock wipingRelayBlock) {
        this.ignoreBytes(2);
        TimeUnit timeUnit = this.parseTimer();
        return timeUnit.getTimeAsString();
    }

    public Object visit(CounterBlock counterBlock) {
        int cnt = 0;
        cnt += this.getByte();
        cnt += this.getByte() << 8;
        cnt += this.getByte() << 16;
        String value = Integer.toString(cnt += this.getByte() << 24);
        this.ignoreBytes(6);
        return value;
    }

    public Object visit(TriggerBlock triggerBlock) {
        this.ignoreBytes(2);
        int fa = 0;
        fa += this.getByte();
        String value = Integer.toString(fa += this.getByte() << 8);
        value = "      ".substring(value.length()) + value;
        this.ignoreBytes(4);
        return value;
    }

    public Object visit(AnalogMuxBlock block) {
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        aqValue = "       ".substring(aqValue.length()) + aqValue;
        this.ignoreBytes(2);
        return aqValue;
    }

    public Object visit(AnalogMathsBlock block) {
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        aqValue = "       ".substring(aqValue.length()) + aqValue;
        this.ignoreBytes(2);
        return aqValue;
    }

    public Object visit(MathDetectionBlock block) {
        int state = this.getByte();
        this.ignoreBytes(2);
        return MathDetectionParameter.getStateText((state & 2) > 0, (state & 1) > 0);
    }

    public Object visit(PWMBlock block) {
        this.ignoreBytes(1);
        int ax = this.parseAnalogValue();
        TimeUnit timeUnit = this.parseTimer();
        StringBuffer value = new StringBuffer();
        value.append(Double.toString(ax)).append("\n");
        value.append(timeUnit.getTimeAsString());
        this.ignoreBytes(2);
        return value.toString();
    }

    public Object visit(RampControlBlock block) {
        this.ignoreBytes(2);
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        aqValue = "       ".substring(aqValue.length()) + aqValue;
        this.ignoreBytes(10);
        return aqValue;
    }

    public Object visit(PIDBlock block) {
        this.ignoreBytes(9);
        int aq = this.parseAnalogValue();
        String aqValue = Integer.toString(aq);
        aqValue = "       ".substring(aqValue.length()) + aqValue;
        int pv = this.parseAnalogValue();
        block.setOnlineTestAQ(aq);
        block.setOnlineTestPV(pv);
        this.ignoreBytes(2);
        return aqValue;
    }

    public Object visit(SoftkeyBlock shiftRegisterBlock) {
        int state = this.getByte();
        String stateString = state > 0 ? "On" : "Off";
        this.ignoreBytes(3);
        return stateString;
    }

    public void setBuffer(int[] buffer) {
        this.fBuffer = buffer;
        this.fBufferPointer = 0;
    }

    protected int getByte() {
        if (this.fBufferPointer < this.fBuffer.length) {
            return this.fBuffer[this.fBufferPointer++] & 0xFF;
        }
        return 0;
    }

    protected TimeUnit parseTimer() {
        int lowByte = this.getByte();
        int highByte = this.getByte();
        TimeUnit timeUnit = null;
        timeUnit = lowByte == 0 && highByte == 0 ? new UnitlessTimeUnit() : this.fCompiler.getNewTimeObject(highByte, lowByte);
        return timeUnit;
    }

    protected int parseAnalogValue() {
        int lowByte = this.getByte();
        int highByte = this.getByte();
        int ax = Util.makeSignedWord(highByte, lowByte);
        return ax;
    }

    protected static class UnitlessTimeUnit
    extends TimeUnit {
        private static final long serialVersionUID = 1L;
        public static final String UNIT_KEY = "dialog.timeParameter.noUnit";

        protected UnitlessTimeUnit() {
        }

        public String getDefaultUnitString() {
            return "";
        }

        public IntValueProperties getHigh() {
            return new IntValueProperties(0, 0, 0, 0, "error.dialog.invalidValue", "Invalid value");
        }

        public int getHighValue() {
            return 0;
        }

        public int[] getLogoTime() {
            return new int[]{0, 0};
        }

        public IntValueProperties getLow() {
            return new IntValueProperties(0, 0, 0, 0, "error.dialog.invalidValue", "Invalid value");
        }

        public int getLowValue() {
            return 0;
        }

        public int getTimeValue() {
            return 0;
        }

        public String getUnitAbbreviation() {
            return " ";
        }

        public String getUnitKey() {
            return UNIT_KEY;
        }

        public void setTime(int high, int low) {
        }

        public TimeUnit setTime(int value) {
            return null;
        }

        public String getLowValueUnitKey() {
            return "";
        }

        public String getLowValueUnitAbbreviation() {
            return "";
        }
    }
}

